import { HtmlTagDescriptor, Plugin } from "vite"
import injectGoogleAnalytics, { GoogleAnaliticsOptions } from "./google-analytics"
import injectTallySoForms, { TallySoOptions } from "./tally-so"

export interface VitePluginRadarOptions {
  allowedModes?: string | string[]
  analytics?: GoogleAnaliticsOptions
  tallySo?: TallySoOptions
}

export function vitePluginInjectTags({
  allowedModes,
  analytics,
  tallySo,
}: VitePluginRadarOptions): Plugin | undefined {
  return {
    name: 'vite-plugin-inject-tags',
    apply(config, { command, mode }) {
      return command === 'build' || command === 'serve' && !config.build?.ssr && matchesMode(mode, allowedModes)
    },

    transformIndexHtml() {
      const tags: HtmlTagDescriptor[] = []

      if (analytics) {
        tags.push(...injectGoogleAnalytics(analytics))
      }

      if (tallySo) {
        tags.push(...injectTallySoForms(tallySo))
      }

      return tags
    },
  }
}

function matchesMode(mode: string, allowedModes: string | string[] | undefined) {
  if (typeof allowedModes === 'string') {
    return allowedModes === mode
  }

  if (Array.isArray(allowedModes)) {
    return !!allowedModes.find(m => m === mode);
  }

  return false;
}

export default vitePluginInjectTags
